package com.rapidminer.krimp.gui;

import javax.swing.table.AbstractTableModel;

import com.rapidminer.krimp.CodeTable;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.tools.Tools;

public class CodeTableModel extends AbstractTableModel {

	private static final long serialVersionUID = 435436021732207040L;
	private static final int COLUMN_SUPPORT = 0;
	private static final int COLUMN_USAGE = 1;
	private static final int COLUMN_CODE_LENGTH_LEFT = 2;
	private static final int COLUMN_CODE_LENGTH_RIGHT = 3;
	private final FrequentItemSet[] codingSet;
	private final double[] codeLengthRight, codeLengthLeft;
	private final int[] usages;
	private int nrOfColumns;

	public CodeTableModel(CodeTable codeTable) {
		codingSet = codeTable.getItemSets().toArray(new FrequentItemSet[0]);
		codeLengthLeft = new double[codingSet.length];
		codeLengthRight = new double[codingSet.length];
		usages = new int[codingSet.length];
		nrOfColumns = 0;
		int i = 0;
		for (FrequentItemSet itemSet : codeTable.getItemSets()) {
			nrOfColumns = Math.max(nrOfColumns, itemSet.getNumberOfItems());
			usages[i] = codeTable.getUsage(itemSet);
			codeLengthLeft[i] = codeTable.getCodeLengthLeft(itemSet);
			codeLengthRight[i++] = codeTable.getCodeLengthRight(itemSet);
		}
		nrOfColumns += 4;
	}

	@Override
	public String getColumnName(int column) {
		if (column == COLUMN_SUPPORT) {
			return "Support";
		} else if (column == COLUMN_USAGE) {
			return "Usage";
		} else if (column == COLUMN_CODE_LENGTH_LEFT) {
			return "Standard Code Length";
		} else if (column == COLUMN_CODE_LENGTH_RIGHT) {
			return "Code Length";
		} else {
			return "Item " + (column - 3);
		}
	}

	@Override
	public int getRowCount() {
		return codingSet.length;
	}

	@Override
	public int getColumnCount() {
		return nrOfColumns;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		if (columnIndex == COLUMN_SUPPORT) {
			return codingSet[rowIndex].getFrequency();
		} else if (columnIndex == COLUMN_USAGE) {
			return usages[rowIndex];
		} else if (columnIndex == COLUMN_CODE_LENGTH_LEFT) {
			return codeLengthLeft[rowIndex];
		} else if (columnIndex == COLUMN_CODE_LENGTH_RIGHT) {
			return Tools.formatNumber(codeLengthRight[rowIndex]);
		} else {
			int actualIndex = columnIndex - 4;
			if (actualIndex < codingSet[rowIndex].getNumberOfItems()) {
				return codingSet[rowIndex].getItem(actualIndex).toString();
			} else {
				return "";
			}
		}
	}

}
